/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2005 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;


namespace Borland.Data.Web
{

	public enum NavigatorButtonType
   {
   	ButtonText,
      ButtonSymbols,
      ButtonIcons
	}

   public interface INavigatorDesignAccess
   {
      string GetDefaultImagesVirtualPath();
      string GetButtonFileName();
   }

	#region DBWebNavigator
	/// <summary>
	/// Data Navigator control
   /// responsible for sending scrolling, undo, apply, refresh
   /// requests to DBWebNavigator
	/// </summary>

	[Designer("Borland.Data.Web.DBWebControlDesigner"),
   ToolboxBitmap(typeof(Borland.Data.Web.DBWebNavigator),
   "Borland.Data.Web.DBWebNavigator.bmp"),
	ToolboxData("<{0}:DBWebNavigator runat=server></{0}:DBWebNavigator>")]
   public class DBWebNavigator : WebControl, IDBWebDataLink, IPostBackDataHandler, INavigatorDesignAccess
   {  // button resources
      //
      protected const string FDefaultRefreshJpg = "NavBtnRefresh.gif";
      protected const string FDefaultInsertJpg = "NavBtnInsert.gif";
      protected const string FDefaultDeleteJpg = "NavBtnDelete.gif";
      protected const string FDefaultFirstJpg = "NavBtnFirst.gif";
      protected const string FDefaultLastJpg = "NavBtnLast.gif";
      protected const string FDefaultNextJpg = "NavBtnNext.gif";
	  protected const string FDefaultPrevJpg = "NavBtnPrev.gif";
      protected const string FDefaultUndoJpg = "NavBtnUndo.gif";
      protected const string FDefaultUndoAllJpg = "NavBtnUndoAll.gif";
      protected const string FDefaultApplyJpg = "NavBtnApply.gif";
      protected const string FDefaultDisabledRefreshJpg = "NavBtnDisabledRefresh.gif";
		protected const string FDefaultDisabledInsertJpg = "NavBtnDisabledInsert.gif";
		protected const string FDefaultDisabledDeleteJpg = "NavBtnDisabledDelete.gif";
      protected const string FDefaultDisabledFirstJpg = "NavBtnDisabledFirst.gif";
      protected const string FDefaultDisabledLastJpg = "NavBtnDisabledLast.gif";
      protected const string FDefaultDisabledNextJpg = "NavBtnDisabledNext.gif";
      protected const string FDefaultDisabledPrevJpg = "NavBtnDisabledPrev.gif";
      protected const string FDefaultDisabledUndoJpg = "NavBtnDisabledUndo.gif";
      protected const string FDefaultDisabledUndoAllJpg = "NavBtnDisabledUndoAll.gif";
	  protected const string FDefaultDisabledApplyJpg = "NavBtnDisabledApply.gif";
		protected const string FDefaultImageVirtualPath = "BorlandImages";
		protected const int DefaultWidth = 15*8;
		protected const int DefaultHeight = 24;
	  protected const int maxGap = 4;
	  protected ArrayList NavButtons;
	  protected ArrayList IconNavButtons;
	  private NavigatorButtonType FButtonType;
	  private System.Web.UI.WebControls.Panel FPanel;
	  private DBWebDataLink FDataLink;
	  private IDBWebDataLink IDataLink;

	  private string FFirstButtonIcon;
	  private string FLastButtonIcon;
	  private string FNextButtonIcon;
	  private string FPreviousButtonIcon;
	  private string FInsertButtonIcon;
	  private string FDeleteButtonIcon;
	  private string FRefreshButtonIcon;
	  private string FApplyButtonIcon;
	  private string FUndoButtonIcon;
	  private string FUndoAllButtonIcon;
	  private bool FClickCalled;

	  private string FImagesVirtualPath;
	  private enum VisibleButtons
	  {
			vbFirstButton = 0x01,
			vbPrevButton = 0x02,
			vbNextButton = 0x04,
			vbLastButton = 0x08,
			vbRefreshButton = 0x10,
			vbInsertButton = 0x20,
			vbDeleteButton = 0x40,
			vbUndoButton = 0x80,
			vbUndoAllButton = 0x100,
			vbApplyButton = 0x200
	  }
	  private VisibleButtons FVisibleButtons;

	  public DBWebNavigator(): base()
	  {
		 NavButtons = new ArrayList();
		 IconNavButtons = new ArrayList();
		 FPanel = new System.Web.UI.WebControls.Panel();
		 FPanel.Wrap = false;
		 FPanel.Width = DefaultWidth*3;
		 FPanel.Height = DefaultHeight;
		 FButtonType = NavigatorButtonType.ButtonSymbols;
		 FDataLink = new DBWebDataLink(this);
		 IDataLink = (FDataLink as IDBWebDataLink);
		 FRefreshButtonIcon = FDefaultRefreshJpg;
		 FInsertButtonIcon = FDefaultInsertJpg;
		 FDeleteButtonIcon = FDefaultDeleteJpg;
		 FFirstButtonIcon = FDefaultFirstJpg;
		 FLastButtonIcon = FDefaultLastJpg;
		 FNextButtonIcon = FDefaultNextJpg;
		 FPreviousButtonIcon = FDefaultPrevJpg;
		 FUndoButtonIcon = FDefaultUndoJpg;
		 FUndoAllButtonIcon = FDefaultUndoAllJpg;
		 FApplyButtonIcon = FDefaultApplyJpg;
		 FImagesVirtualPath = FDefaultImageVirtualPath;
		 FVisibleButtons =
		 VisibleButtons.vbFirstButton |
		 VisibleButtons.vbPrevButton |
		 VisibleButtons.vbNextButton |
		 VisibleButtons.vbLastButton |
		 VisibleButtons.vbRefreshButton |
		 VisibleButtons.vbInsertButton |
		 VisibleButtons.vbDeleteButton |
		 VisibleButtons.vbUndoButton |
		 VisibleButtons.vbUndoAllButton |
		 VisibleButtons.vbApplyButton;
		 FClickCalled = false;
		 SetButtonsWidth();
	  }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
	  }


      protected override void OnPreRender(EventArgs args)
	  {
         DataBind();
      }

	  [LocalizableCategoryAttribute("NavigatorClick")]
	  [LocalizableDescriptionAttribute("NavigatorClick")]
	  public event DBWebNavigatorEvent Click;

      #region IPostBackDataHandler
	  // RaisePostDataChangedEvent is called prior to DataBind()
	  // DataSet and related properties are NOT available here
	  // Child controls are not available
      bool IPostBackDataHandler.LoadPostData(string postDataKey,
               NameValueCollection postCollection)
      {
         if( this.Visible )
            FDataLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

      void IPostBackDataHandler.RaisePostDataChangedEvent()
      {
      }
      #endregion

      #region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
         get
         {
            return IDataLink.TableName;
         }
         set
         {
            IDataLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
         get
         {
         	return IDataLink.DBDataSource;
         }
         set
         {
         	IDataLink.DBDataSource = value;
         }
      }
      #endregion

      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue("")]
        [LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
		get
         {
	      	return IDataLink.TableName;
         }
      	set
         {
	      	IDataLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
		
		[LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IDataLink.DBDataSource;
         }
         set
			{
				IDataLink.DBDataSource = value;
			}
      }

		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(FDefaultImageVirtualPath)]
        [LocalizableDescriptionAttribute("ImagesVirtualPath")]
	  public string ImagesVirtualPath
      {
      	get
         {
         	return FImagesVirtualPath;
         }
         set
         {
         	FImagesVirtualPath = value;
         }
      }

	  protected bool HasRecords()
      {
         if( FDataLink == null || ClassUtils.IsDesignTime(Page) )
         	return true;
      	if( !FDataLink.IsDataBound )
         	return true;
         return IDataLink.DBDataSource.GetDisplayRowCount(Page, TableName) > 0;
      }

      protected bool ShowDeleteButton()
      {
         if( FDataLink == null || ClassUtils.IsDesignTime(Page) )
				return true;
			if( !FDataLink.IsDataBound )
				return true;
         if( !IDataLink.DBDataSource.HasDetailRecords(Page, TableName) )
			return true;
         return (IDataLink.DBDataSource as DBWebDataSource).CascadingDeletes != CascadingDeleteOption.noMasterDelete;
      }

      protected bool DataSourceHasApplyEvent()
      {
         if( ClassUtils.IsDesignTime(Page) )
         	return true;
      	else if( FDataLink == null )
         	return false;
         else if( !FDataLink.IsDataBound )
         	return false;
		 else if( Click != null )
         	return true;
         return (IDataLink.DBDataSource as IDBDataSource).HasApplyEvent();
      }

      #region INavigatorDesignAccess
      string INavigatorDesignAccess.GetDefaultImagesVirtualPath()
      {
      	return FDefaultImageVirtualPath;
      }

      string INavigatorDesignAccess.GetButtonFileName()
      {
      	return FDefaultFirstJpg;
      }
      #endregion INavigatorDesignAccess;

      #region Layout
		[LocalizableCategoryAttribute("Layout")]
      public override Unit Width
      {
      	get
         {
         	return FPanel.Width;
         }
         set
			{
				FPanel.Width = value;
				SetButtonsWidth();
			}
		}


		[LocalizableCategoryAttribute("Layout")]
		public override Unit Height
		{
			get
			{
				return FPanel.Height;
			}
			set
			{
				FPanel.Height = value;
			}
		}


		#endregion

		#region AddButtons

		private bool HasButtons
		{
			get
			{
				return ((FVisibleButtons & VisibleButtons.vbFirstButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbPrevButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbNextButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbLastButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbRefreshButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbInsertButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbDeleteButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbUndoButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbUndoAllButton) != 0) ||
					 ((FVisibleButtons & VisibleButtons.vbApplyButton) != 0);
			}
		}

		protected void AddButtons()
		{
			NavButtons.Clear();
			IconNavButtons.Clear();
			if( HasRecords() )
			{
				if ((FVisibleButtons & VisibleButtons.vbFirstButton) != 0)
					AddButton(DBWebConst.sFirstText, true);
				if ((FVisibleButtons & VisibleButtons.vbPrevButton) != 0)
					AddButton(DBWebConst.sPrevText, true);
				if ((FVisibleButtons & VisibleButtons.vbNextButton) != 0)
					AddButton(DBWebConst.sNextText, true);
				if ((FVisibleButtons & VisibleButtons.vbLastButton) != 0)
					AddButton(DBWebConst.sLastText, true);
			}
			else
			{
            if ((FVisibleButtons & VisibleButtons.vbFirstButton) != 0)
               AddButton(DBWebConst.sFirstText, false);
				if ((FVisibleButtons & VisibleButtons.vbPrevButton) != 0)
               AddButton(DBWebConst.sPrevText, false);
            if ((FVisibleButtons & VisibleButtons.vbNextButton) != 0)
               AddButton(DBWebConst.sNextText, false);
            if ((FVisibleButtons & VisibleButtons.vbLastButton) != 0)
               AddButton(DBWebConst.sLastText, false);
         }
		 if ((FVisibleButtons & VisibleButtons.vbInsertButton) != 0)
         {
            if( !FDataLink.DataSourceIsSorted() )
               AddButton(DBWebConst.sInsertText, true);
		 }
		 if ((FVisibleButtons & VisibleButtons.vbDeleteButton) != 0)
			 if( HasRecords() && ShowDeleteButton() )
				 AddButton(DBWebConst.sDeleteText, true);
			 else
				 AddButton(DBWebConst.sDeleteText, false);
		 if ((FVisibleButtons & VisibleButtons.vbApplyButton) != 0)
			 if( DataSourceHasApplyEvent() )
				 AddButton(DBWebConst.sApplyText, true);
			 else
				 AddButton(DBWebConst.sApplyText, false);
		 if( !FDataLink.DataSourceHasDelta(Page) )
		 {
			if ((FVisibleButtons & VisibleButtons.vbRefreshButton) != 0)
			{
				if( FDataLink.DataSourceHasAnyChanges(Page) )
					AddButton(DBWebConst.sRefreshText, false);
				else
					AddButton(DBWebConst.sRefreshText, true);
			}
			if ((FVisibleButtons & VisibleButtons.vbUndoButton) != 0)
				AddButton(DBWebConst.sUndoText, false);
			if ((FVisibleButtons & VisibleButtons.vbUndoAllButton) != 0)
				AddButton(DBWebConst.sUndoAllText, false);
		 }
		 else
		 {
			if ((FVisibleButtons & VisibleButtons.vbRefreshButton) != 0)
				AddButton(DBWebConst.sRefreshText, false);
			if ((FVisibleButtons & VisibleButtons.vbUndoButton) != 0)
				AddButton(DBWebConst.sUndoText, true);
			if ((FVisibleButtons & VisibleButtons.vbUndoAllButton) != 0)
				AddButton(DBWebConst.sUndoAllText, true);
		 }
       }

       private void AddButton(string Text, bool enabled)
		 {
			if( FButtonType == NavigatorButtonType.ButtonIcons )
			{
				AddIconButton(Text, enabled);
				return;
			}
			string sText = BdwResources.GetString(Text);
			Button tempButton = new Button();
			tempButton.ID = IDataLink.TableName + DBWebConst.Splitter + Text;
			tempButton.Enabled = enabled;
			if( FButtonType == NavigatorButtonType.ButtonSymbols )
			{
				tempButton.Text  = GetSymbolForText(Text);
				tempButton.Font.Bold = true;
				tempButton.ToolTip = sText;
			}
			else
			{
				tempButton.Text = sText;
				tempButton.ToolTip = sText;
			}
			tempButton.CommandName = Text;
			tempButton.Page = this.Page;
			ClassUtils.SetInnerAppearanceProperties( tempButton, this );
			tempButton.Height = new Unit(FPanel.Height.Value);
			NavButtons.Add(tempButton);
		}

      private string GetImageUrlForButton(string text, bool Enabled)
      {
      	string sImageUrl = "";
		if( text == DBWebConst.sNextText )
         {
         	if( !Enabled && FNextButtonIcon == FDefaultNextJpg )
	         	sImageUrl = FDefaultDisabledNextJpg;
            else
	         	sImageUrl = FNextButtonIcon;
         }
      	else if( text == DBWebConst.sPrevText )
         {
				if( !Enabled && FPreviousButtonIcon == FDefaultPrevJpg )
	         	sImageUrl = FDefaultDisabledPrevJpg;
            else
				sImageUrl = FPreviousButtonIcon;
         }
      	else if( text == DBWebConst.sFirstText )
         {
         	if( !Enabled && FFirstButtonIcon == FDefaultFirstJpg )
	         	sImageUrl = FDefaultDisabledFirstJpg;
            else
		      	sImageUrl = FFirstButtonIcon;
         }
      	else if( text == DBWebConst.sLastText )
         {
         	if( !Enabled && FLastButtonIcon == FDefaultLastJpg )
	         	sImageUrl = FDefaultDisabledLastJpg;
            else
	         	sImageUrl = FLastButtonIcon;
         }
		else if( text == DBWebConst.sApplyText )
         {
         	if( !Enabled && FApplyButtonIcon == FDefaultApplyJpg )
            	sImageUrl = FDefaultDisabledApplyJpg;
            else
         		sImageUrl = FApplyButtonIcon;
         }
      	else if( text == DBWebConst.sRefreshText )
         {
         	if( !Enabled && FRefreshButtonIcon == FDefaultRefreshJpg )
            	sImageUrl = FDefaultDisabledRefreshJpg;
            else
				sImageUrl = FRefreshButtonIcon;
         }
      	else if( text == DBWebConst.sDeleteText )
         {
				if( !Enabled && FDeleteButtonIcon == FDefaultDeleteJpg )
            	sImageUrl = FDefaultDisabledDeleteJpg;
            else
	         	sImageUrl = FDeleteButtonIcon;
         }
      	else if( text == DBWebConst.sInsertText )
         {
         	if( !Enabled && FInsertButtonIcon == FDefaultInsertJpg )
            	sImageUrl = FDefaultDisabledInsertJpg;
            else
	         	sImageUrl = FInsertButtonIcon;
         }
		else if( text == DBWebConst.sUndoText )
         {
         	if( !Enabled && FUndoButtonIcon == FDefaultUndoJpg )
            	sImageUrl = FDefaultDisabledUndoJpg;
            else
	         	sImageUrl = FUndoButtonIcon;
         }
      	else if( text == DBWebConst.sUndoAllText )
         {
         	if( !Enabled && FUndoAllButtonIcon == FDefaultUndoAllJpg )
            	sImageUrl = FDefaultDisabledUndoAllJpg;
            else
				sImageUrl = FUndoAllButtonIcon;
         }
      	else
         	return null;
         return ClassUtils.GetFullVirtualDirectory(FImagesVirtualPath) + sImageUrl;
      }

      private void AddIconButton(string Text, bool enabled)
      {
			ImageButton tempButton = new ImageButton();
         tempButton.ID = IDataLink.TableName + DBWebConst.Splitter + Text;
         tempButton.Enabled = enabled;
         tempButton.Page = this.Page;
         ClassUtils.SetInnerAppearanceProperties( tempButton, this );
         tempButton.ImageUrl = GetImageUrlForButton(Text, enabled);
         tempButton.ToolTip = BdwResources.GetString(Text);
			tempButton.CommandName = Text;
			tempButton.Height = new Unit(FPanel.Height.Value);
         IconNavButtons.Add(tempButton);
      }

      private string GetSymbolForText(string Text)
      {
      	if( Text == DBWebConst.sFirstText )
         	return "|<";
      	else if( Text == DBWebConst.sLastText )
         	return ">|";
      	else if( Text == DBWebConst.sNextText )
			return ">>";
      	else if( Text == DBWebConst.sPrevText )
         	return "<<";
      	else if( Text == DBWebConst.sInsertText )
         	return "+";
      	else if( Text == DBWebConst.sDeleteText )
         	return "_";
      	else if( Text == DBWebConst.sRefreshText )
         	return "[<]";
      	else if( Text == DBWebConst.sApplyText )
         	return "[>]";
      	else if( Text == DBWebConst.sUndoText )
         	return "X";
			else if( Text == DBWebConst.sUndoAllText )
         	return "XX";
         return "";
	  }


      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
      LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("NextButtonIcon")]
      public string NextButtonIcon
      {
      	get
         {
         	return FNextButtonIcon;
		 }
         set
         {
         	FNextButtonIcon = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
      LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("PreviousButtonIcon")]
      public string PreviousButtonIcon
      {
      	get
         {
         	return FPreviousButtonIcon;
		 }
         set
         {
         	FPreviousButtonIcon = value;
			}
      }

      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
      LocalizableCategoryAttribute("ButtonIcon"),
	  DefaultValue(null)]
      [LocalizableDescriptionAttribute("FirstButtonIcon")]
      public string FirstButtonIcon
	  {
      	get
         {
         	return FFirstButtonIcon;
         }
         set
         {
         	FFirstButtonIcon = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
      LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("LastButtonIcon")]
      public string LastButtonIcon
	  {
      	get
         {
         	return FLastButtonIcon;
         }
         set
         {
         	FLastButtonIcon = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
	  LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("InsertButtonIcon")]
      public string InsertButtonIcon
      {
      	get
         {
         	return FInsertButtonIcon;
         }
         set
         {
         	FInsertButtonIcon = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
	  LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("DeleteButtonIcon")]
      public string DeleteButtonIcon
      {
      	get
         {
         	return FDeleteButtonIcon;
         }
         set
         {
         	FDeleteButtonIcon = value;
		 }
      }


      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
      LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("ApplyButtonIcon")]
      public string ApplyButtonIcon
      {
      	get
         {
         	return FApplyButtonIcon;
         }
		 set
         {
			FApplyButtonIcon = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
      LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("RefreshButtonIcon")]
      public string RefreshButtonIcon
      {
      	get
         {
			return FRefreshButtonIcon;
         }
         set
         {
         	FRefreshButtonIcon = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
      LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("UndoButtonIcon")]
      public string UndoButtonIcon
      {
      	get
         {
			return FUndoButtonIcon;
         }
         set
         {
         	FUndoButtonIcon = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.DBWebSelectJpg), typeof(UITypeEditor)),
      LocalizableCategoryAttribute("ButtonIcon"),
      DefaultValue(null)]
      [LocalizableDescriptionAttribute("UndoAllButtonIcon")]
	  public string UndoAllButtonIcon
      {
      	get
         {
         	return FUndoAllButtonIcon;
         }
         set
         {
         	FUndoAllButtonIcon = value;
         }
      }



	  [LocalizableCategoryAttribute(DBTypes.sDBWebControl),
	   DefaultValue(NavigatorButtonType.ButtonSymbols)]
	  [LocalizableDescriptionAttribute("ButtonType")]
	  public NavigatorButtonType ButtonType
	  {
		get
		{
			return FButtonType;
		 }
		 set
		 {
			if( FButtonType != value )
				FButtonType = value;
		 }
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
      [LocalizableDescriptionAttribute("FirstButtonVisible")]
	  public bool FirstButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbFirstButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbFirstButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbFirstButton;
			SetButtonsWidth();
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
      [LocalizableDescriptionAttribute("PreviousButtonVisible")]
	  public bool PrevButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbPrevButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbPrevButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbPrevButton;
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
      [LocalizableDescriptionAttribute("NextButtonVisible")]
	  public bool NextButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbNextButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbNextButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbNextButton;
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
      [LocalizableDescriptionAttribute("LastButtonVisible")]
	  public bool LastButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbLastButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbLastButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbLastButton;
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
	  [LocalizableDescriptionAttribute("RefreshButtonVisible")]
	  public bool RefreshButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbRefreshButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbRefreshButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbRefreshButton;
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
      [LocalizableDescriptionAttribute("InsertButtonVisible")]
	  public bool InsertButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbInsertButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbInsertButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbInsertButton;
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
      [LocalizableDescriptionAttribute("DeleteButtonVisible")]
	  public bool DeleteButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbDeleteButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbDeleteButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbDeleteButton;
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
      [LocalizableDescriptionAttribute("UndoButtonVisible")]
	  public bool UndoButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbUndoButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbUndoButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbUndoButton;
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
	  [LocalizableDescriptionAttribute("UndoAllButtonVisible")]
	  public bool UndoAllButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbUndoAllButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbUndoAllButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbUndoAllButton;
		}
	  }

	  [LocalizableCategory("VisibleButtons"), DefaultValue(true)]
      [LocalizableDescriptionAttribute("ApplyButtonVisible")]
	  public bool ApplyButtonVisible
	  {
		get
		{
			return ((FVisibleButtons & VisibleButtons.vbApplyButton) != 0);
		}
		set
		{
			if (value)
				FVisibleButtons |= VisibleButtons.vbApplyButton;
			else
				FVisibleButtons &= ~VisibleButtons.vbApplyButton;
		}
	  }

	  #endregion

	  #region RenderHtml

	  // writes html out at runtime
		protected override void Render(HtmlTextWriter output)
		{
      	bool error = ClassUtils.OutputErrors(Page, output, IDataLink);
			if( !error || (IDataLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
			{
				if( HasButtons )
					output.Write(Text);
			}
			else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
		 	}
		}

		private void SetButtonsWidth()
		{
			AddButtons();
			int count;
			if( ButtonType == NavigatorButtonType.ButtonIcons )
				count = IconNavButtons.Count;
			else
				count = NavButtons.Count;
			if(  count == 0 )
				return;
			double PanelBorder =  ((FPanel.BorderWidth.Value * 2) / count) + 1;
			double dWidth = (FPanel.Width.Value / count) - PanelBorder;
			int iWidth = Convert.ToInt32(dWidth);
			// Can't resize button width smaller then 0.
			if (iWidth < 0) 
				iWidth = 0;
			if( ButtonType == NavigatorButtonType.ButtonIcons )
			{
				ImageButton ib = null;
					for( int i = 0; i < IconNavButtons.Count; i++ )
					{
						ib = (IconNavButtons[i] as ImageButton);
						if( !ClassUtils.IsDesignTime(Page) )
							ib.ID = ClassUtils.GetPageName(Page) + ib.ID;
						ib.Width = new Unit(iWidth);
					}
			}
			else
			{
				Button b = null;
				for( int i = 0; i < NavButtons.Count; i++ )
				{
					b = (NavButtons[i] as Button);
					if( !ClassUtils.IsDesignTime(Page) )
						b.ID = ClassUtils.GetPageName(Page) + b.ID;
					b.Width = new Unit(iWidth);
				}
			} 
			double iButtonsWidth = iWidth * NavButtons.Count;
			double iExtraPanelPixels = (FPanel.Width.Value - (FPanel.BorderWidth.Value * 2 )) - (2 + iButtonsWidth);
		}
	  #endregion

	  protected virtual void DoOnClick()
	  {
        String PageName = ClassUtils.GetPageName(Page);
		object buttonObj = Page.Session[PageName + IDataLink.TableName + DBWebConst.sLastButtonSelected];
		if( buttonObj != null )
		{
			string sButton = buttonObj.ToString();
			Object o = null;
			if( FDataLink.IsDataBound )
				o = IDataLink.DBDataSource.GetTableOrView(Page, IDataLink.TableName);
			DBWebButtonClickArgs e = new DBWebButtonClickArgs(sButton, o);
			Click(this as object, e);
		}
		FClickCalled = true;
	  }

	  public override void DataBind()
	  {
		 try
		 {
			base.DataBind();
			if( !HasButtons )
				return;
			if( !ClassUtils.IsDesignTime(Page) )
			{
				if( Click != null && !FClickCalled )
					DoOnClick();
			}
			ClassUtils.SetOuterAppearanceProperties( FPanel, this );
			SetButtonsWidth();
		 }
		 catch(Exception ex)
		 {
			if( !ClassUtils.IsDesignTime(Page) )
			{
				Page.Response.Write(ClassUtils.GetInternalError(Page, IDataLink, ex, this.ID));
			}
			else
				throw new Exception(ex.Message);
		 }
	  }


		protected string Text
		{
			get
			{
			StringWriter sw = new StringWriter();
			HtmlTextWriter tw = new HtmlTextWriter(sw);
				DataBind();
				SetButtonsWidth();
				ClassUtils.AddStyleToWebControl(FPanel, this.Style);
            FPanel.RenderBeginTag(tw);
            tw.Write("<table><tr>");
            if( ButtonType == NavigatorButtonType.ButtonIcons )
            {
					for( int i = 0; i < IconNavButtons.Count; i++ )
					{
               	tw.Write("<td>");
						ImageButton b = (IconNavButtons[i] as ImageButton);
						b.RenderControl(tw);
               	tw.Write("</td>");
					}
            }
            else
            {
					for( int i = 0; i < NavButtons.Count; i++ )
					{
               	tw.Write("<td>");
						Button b = (NavButtons[i] as Button);
						b.RenderControl(tw);
               	tw.Write("</td>");
					}
            }
            tw.Write("</tr></table>");
            FPanel.RenderEndTag(tw);
            return sw.ToString();
			}
		}
   }
   #endregion

}
